/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
import lotus.domino.*;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class DocAlsXMLJavaAgent extends AgentBase {

	public void NotesMain() {
		DxlExporter exporter = null; 
		Document doc = null;
		Document responseDoc = null;
		try {
			
			Session session = getSession();
			String server = session.getAgentContext().getCurrentDatabase().getServer();
			System.out.println ("Server: " + server);
			if (server != null && !server.equals ("")) {
				System.out.println (THREAD_ERROR);
				return;
			}
			Database db = session.getAgentContext().getCurrentDatabase();
			doc = session.getAgentContext().getDocumentContext();
			// Export to response Document
			exporter = session.createDxlExporter();

			String result = exporter.exportDxl(doc);
			responseDoc = db.createDocument();
			responseDoc.replaceItemValue("Form", "FO_Report");
			RichTextItem rt = responseDoc.createRichTextItem("Body");
			niceAppend(rt, result);
			responseDoc.replaceItemValue(
				"F_Titel",
				"XML fr Dok. \"" + doc.getItemValueString("F_Titel") + "\"");
			responseDoc.makeResponse(doc);
			responseDoc.save(true, false);
		} catch (NotesException e) {
			e.printStackTrace();
		} finally {
			try {
				if (exporter != null) {
					System.out.println (exporter.getLog());
					exporter.recycle();
				}
				if (doc != null) {doc.recycle();}
			} catch (NotesException e1) {
				e1.printStackTrace();
			}
		}
	}

	/**
	 * Formatiert den String s, von dem Erwartet wird, dass er XML enthlt
	 * und speichert ihn im RichText Item rt.
	 * 
	 * @param rt - RichText Item in das der String s eingefgt werden soll.
	 * @param s - Einzufgender String
	 * @throws NotesException
	 */
	private static void niceAppend(RichTextItem rt, String s) throws NotesException {
		char[] ca = s.toCharArray();
		StringBuffer line = new StringBuffer();
		for (int i = 0, l = ca.length; i < l - 1; i++) {
			line.append(ca[i]);
			if (ca[i] == '<' && ca[i + 1] == '/') {
				while (i < l - 1) {
						i += 1; 
						line.append(ca[i]);
						if (ca[i] == '>') {
							rt.appendText(line.toString());
							rt.addNewLine(1);
							line = new StringBuffer();
						}
				}
			}
		}
		rt.appendText("" + ca[ca.length - 1]);
	}
	
	private String THREAD_ERROR = "Dieser Agent kann nur auf einem lokalen\n" +
	" Notes Client ausgefhrt werden, da er sich auf das\n" +
	" Context Dokument bezieht und der DXL Exporter\n" +
	" ein zu exportierendes Dokument in einem eigenen Thread\n" +
	" ffnet, so dass das Context Dokument in zwei Threads gleichzeitig\n" +
	" geffnet wre. Dies ist nicht zulssig.\n" +
	" Replizieren Sie die Datenbank in ihr lokales Dataverzeichnis.";

}